define(['jquery','uiComponent','ko','Magento_Customer/js/model/customer','Magento_Customer/js/action/check-email-availability','Magento_Customer/js/action/login','Magento_Checkout/js/model/quote','Magento_Checkout/js/checkout-data','Magento_Checkout/js/model/full-screen-loader','mage/validation'],function($,Component,ko,customer,checkEmailAvailability,loginAction,quote,checkoutData,fullScreenLoader){'use strict';var validatedEmail=checkoutData.getValidatedEmailValue();if(validatedEmail&&!customer.isLoggedIn()){quote.guestEmail=validatedEmail;}
return Component.extend({defaults:{template:'Magento_Checkout/form/element/email',email:checkoutData.getInputFieldEmailValue(),emailFocused:false,isLoading:false,isPasswordVisible:false,listens:{email:'emailHasChanged',emailFocused:'validateEmail'}},checkDelay:2000,checkRequest:null,isEmailCheckComplete:null,isCustomerLoggedIn:customer.isLoggedIn,forgotPasswordUrl:window.checkoutConfig.forgotPasswordUrl,emailCheckTimeout:0,initObservable:function(){this._super().observe(['email','emailFocused','isLoading','isPasswordVisible']);return this;},initConfig:function(){this._super();this.isPasswordVisible=this.resolveInitialPasswordVisibility();return this;},emailHasChanged:function(){var self=this;clearTimeout(this.emailCheckTimeout);if(self.validateEmail()){quote.guestEmail=self.email();checkoutData.setValidatedEmailValue(self.email());}
this.emailCheckTimeout=setTimeout(function(){if(self.validateEmail()){self.checkEmailAvailability();}else{self.isPasswordVisible(false);}},self.checkDelay);checkoutData.setInputFieldEmailValue(self.email());},checkEmailAvailability:function(){this.validateRequest();this.isEmailCheckComplete=$.Deferred();this.isLoading(true);this.checkRequest=checkEmailAvailability(this.isEmailCheckComplete,this.email());$.when(this.isEmailCheckComplete).done(function(){this.isPasswordVisible(false);}.bind(this)).fail(function(){this.isPasswordVisible(true);checkoutData.setCheckedEmailValue(this.email());}.bind(this)).always(function(){this.isLoading(false);}.bind(this));},validateRequest:function(){if(this.checkRequest!=null&&$.inArray(this.checkRequest.readyState,[1,2,3])){this.checkRequest.abort();this.checkRequest=null;}},validateEmail:function(focused){var loginFormSelector='form[data-role=email-with-possible-login]',usernameSelector=loginFormSelector+' input[name=username]',loginForm=$(loginFormSelector),validator;loginForm.validation();if(focused===false&&!!this.email()){return!!$(usernameSelector).valid();}
validator=loginForm.validate();return validator.check(usernameSelector);},login:function(loginForm){var loginData={},formDataArray=$(loginForm).serializeArray();formDataArray.forEach(function(entry){loginData[entry.name]=entry.value;});if(this.isPasswordVisible()&&$(loginForm).validation()&&$(loginForm).validation('isValid')){fullScreenLoader.startLoader();loginAction(loginData).always(function(){fullScreenLoader.stopLoader();});}},resolveInitialPasswordVisibility:function(){if(checkoutData.getInputFieldEmailValue()!==''){return checkoutData.getInputFieldEmailValue()===checkoutData.getCheckedEmailValue();}
return false;}});});