define(['jquery','underscore','Magento_Checkout/js/view/payment/default','Magento_Braintree/js/view/payment/adapter','Magento_Checkout/js/model/quote','Magento_Checkout/js/model/full-screen-loader','Magento_Checkout/js/model/payment/additional-validators','Magento_Vault/js/view/payment/vault-enabler','Magento_Checkout/js/action/create-billing-address','mage/translate'],function($,_,Component,Braintree,quote,fullScreenLoader,additionalValidators,VaultEnabler,createBillingAddress,$t){'use strict';return Component.extend({defaults:{template:'Magento_Braintree/payment/paypal',code:'braintree_paypal',active:false,paymentMethodNonce:null,grandTotalAmount:null,isReviewRequired:false,customerEmail:null,additionalData:{},clientConfig:{dataCollector:{paypal:true},onReady:function(checkout){Braintree.checkout=checkout;this.additionalData['device_data']=checkout.deviceData;this.enableButton();Braintree.onReady();},onPaymentMethodReceived:function(response){this.beforePlaceOrder(response);}},imports:{onActiveChange:'active'}},initObservable:function(){var self=this;this._super().observe(['active','isReviewRequired','customerEmail']);this.vaultEnabler=new VaultEnabler();this.vaultEnabler.setPaymentCode(this.getVaultCode());this.vaultEnabler.isActivePaymentTokenEnabler.subscribe(function(){self.onVaultPaymentTokenEnablerChange();});this.grandTotalAmount=quote.totals()['base_grand_total'];quote.totals.subscribe(function(){if(self.grandTotalAmount!==quote.totals()['base_grand_total']){self.grandTotalAmount=quote.totals()['base_grand_total'];}});this.isReviewRequired(false);this.initClientConfig();return this;},getCode:function(){return this.code;},getTitle:function(){return window.checkoutConfig.payment[this.getCode()].title;},isActive:function(){var active=this.getCode()===this.isChecked();this.active(active);return active;},onActiveChange:function(isActive){if(!isActive){return;}
this.reInitPayPal();},initClientConfig:function(){this.clientConfig=_.extend(this.clientConfig,this.getPayPalConfig());_.each(this.clientConfig,function(fn,name){if(typeof fn==='function'){this.clientConfig[name]=fn.bind(this);}},this);},setPaymentMethodNonce:function(paymentMethodNonce){this.paymentMethodNonce=paymentMethodNonce;},setBillingAddress:function(customer,address){var billingAddress={street:[address.streetAddress],city:address.locality,postcode:address.postalCode,countryId:address.countryCodeAlpha2,email:customer.email,firstname:customer.firstName,lastname:customer.lastName,telephone:customer.phone};billingAddress['region_code']=address.region;billingAddress=createBillingAddress(billingAddress);quote.billingAddress(billingAddress);},beforePlaceOrder:function(data){this.setPaymentMethodNonce(data.nonce);if(quote.billingAddress()===null&&typeof data.details.billingAddress!=='undefined'){this.setBillingAddress(data.details,data.details.billingAddress);}
if(this.isSkipOrderReview()){this.placeOrder();}else{this.customerEmail(data.details.email);this.isReviewRequired(true);}},reInitPayPal:function(){if(Braintree.checkout){Braintree.checkout.teardown(function(){Braintree.checkout=null;});}
this.disableButton();this.clientConfig.paypal.amount=this.grandTotalAmount;Braintree.setConfig(this.clientConfig);Braintree.setup();},getLocale:function(){return window.checkoutConfig.payment[this.getCode()].locale;},isAllowOverrideShippingAddress:function(){return window.checkoutConfig.payment[this.getCode()].isAllowShippingAddressOverride;},getPayPalConfig:function(){var totals=quote.totals(),config={},isActiveVaultEnabler=this.isActiveVault();config.paypal={container:'paypal-container',singleUse:!isActiveVaultEnabler,headless:true,amount:this.grandTotalAmount,currency:totals['base_currency_code'],locale:this.getLocale(),enableShippingAddress:true,onError:function(){this.paymentMethodNonce=null;},onUnsupported:function(){this.paymentMethodNonce=null;}};config.paypal.shippingAddressOverride=this.getShippingAddress();if(this.getMerchantName()){config.paypal.displayName=this.getMerchantName();}
return config;},getShippingAddress:function(){var address=quote.shippingAddress();if(_.isNull(address.postcode)||_.isUndefined(address.postcode)){return{};}
return{recipientName:address.firstname+' '+address.lastname,streetAddress:address.street[0],locality:address.city,countryCodeAlpha2:address.countryId,postalCode:address.postcode,region:address.regionCode,phone:address.telephone,editable:this.isAllowOverrideShippingAddress()};},getMerchantName:function(){return window.checkoutConfig.payment[this.getCode()].merchantName;},getData:function(){var data={'method':this.getCode(),'additional_data':{'payment_method_nonce':this.paymentMethodNonce}};data['additional_data']=_.extend(data['additional_data'],this.additionalData);this.vaultEnabler.visitAdditionalData(data);return data;},getPaymentAcceptanceMarkSrc:function(){return window.checkoutConfig.payment[this.getCode()].paymentAcceptanceMarkSrc;},getVaultCode:function(){return window.checkoutConfig.payment[this.getCode()].vaultCode;},isSkipOrderReview:function(){return window.checkoutConfig.payment[this.getCode()].skipOrderReview;},isActiveVault:function(){return this.vaultEnabler.isVaultEnabled()&&this.vaultEnabler.isActivePaymentTokenEnabler();},onVaultPaymentTokenEnablerChange:function(){this.clientConfig.paypal.singleUse=!this.isActiveVault();this.reInitPayPal();},disableButton:function(){fullScreenLoader.stopLoader(true);fullScreenLoader.startLoader();$('[data-button="place"]').attr('disabled','disabled');},enableButton:function(){$('[data-button="place"]').removeAttr('disabled');fullScreenLoader.stopLoader();},payWithPayPal:function(){if(additionalValidators.validate()){try{Braintree.checkout.paypal.initAuthFlow();}catch(e){this.messageContainer.addErrorMessage({message:$t('Payment '+this.getTitle()+' can\'t be initialized.')});}}},getButtonTitle:function(){return this.isSkipOrderReview()?'Pay with PayPal':'Continue to PayPal';},getButtonId:function(){return this.getCode()+(this.isSkipOrderReview()?'_pay_with':'_continue_to');}});});