define(['ko','Magento_Ui/js/lib/view/utils/async','underscore','Magento_Ui/js/lib/view/utils/raf','uiRegistry','uiClass'],function(ko,$,_,raf,registry,Class){'use strict';var hasClassList=(function(){var list=document.createElement('_').classList;return!!list&&!list.toggle('_test',false);})();function toggleClass(elem){var classList=elem.classList,args=Array.prototype.slice.call(arguments,1),$elem;if(hasClassList){classList.toggle.apply(classList,args);}else{$elem=$(elem);$elem.toggleClass.apply($elem,args);}}
return Class.extend({defaults:{selectors:{content:'.timeline-content',timeUnit:'.timeline-unit',item:'.timeline-item:not([data-role=no-data-msg])',event:'.timeline-event'}},initialize:function(){_.bindAll(this,'refresh','initContent','initItem','initTimeUnit','getItemBindings','updateItemsPosition','onScaleChange','onEventElementRender','onWindowResize','onContentScroll','onDataReloaded','onToStartClick','onToEndClick');this._super().initModel().waitContent();return this;},initModel:function(){var model=registry.get(this.model);model.on('scale',this.onScaleChange);model.source.on('reloaded',this.onDataReloaded);this.model=model;return this;},waitContent:function(){$.async({selector:this.selectors.content,component:this.model},this.initContent);return this;},initContent:function(content){this.$content=content;$(content).on('scroll',this.onContentScroll);$(window).on('resize',this.onWindowResize);$.async(this.selectors.item,content,this.initItem);$.async(this.selectors.event,content,this.onEventElementRender);$.async(this.selectors.timeUnit,content,this.initTimeUnit);this.refresh();return this;},initItem:function(elem){$(elem).bindings(this.getItemBindings).on('click','._toend',this.onToEndClick).on('click','._tostart',this.onToStartClick);return this;},initTimeUnit:function(elem){$(elem).bindings(this.getTimeUnitBindings());return this;},refresh:function(){raf(this.refresh);if(this._update){this._update=false;this.updateItemsPosition();}},getTimeUnitBindings:function(){return{style:{width:ko.computed(function(){return this.getTimeUnitWidth()+'%';}.bind(this))}};},getItemBindings:function(ctx){return{style:{width:ko.computed(function(){return this.getItemWidth(ctx.$row())+'%';}.bind(this)),'margin-left':ko.computed(function(){return this.getItemMargin(ctx.$row())+'%';}.bind(this))}};},getTimeUnitWidth:function(){return 100 / this.model.scale;},getItemWidth:function(record){var days=0;if(record){days=this.model.getDaysLength(record);}
return this.getTimeUnitWidth()*days;},getItemMargin:function(record){var offset=0;if(record){offset=this.model.getStartDelta(record);}
return this.getTimeUnitWidth()*offset;},getItems:function(){var items=this.$content.querySelectorAll(this.selectors.item);return _.toArray(items);},updateItemsPosition:function(){this.getItems().forEach(this.updatePositionFor,this);return this;},updatePositionFor:function($elem){var $event=$elem.querySelector(this.selectors.event),leftEdge=this.getLeftEdgeFor($elem),rightEdge=this.getRightEdgeFor($elem);if($event){$event.style.left=Math.max(-leftEdge,0)+'px';$event.style.right=Math.max(rightEdge,0)+'px';}
toggleClass($elem,'_scroll-start',leftEdge<0);toggleClass($elem,'_scroll-end',rightEdge>0);return this;},toStartOf:function(elem){var leftEdge=this.getLeftEdgeFor(elem);this.$content.scrollLeft+=leftEdge;return this;},toEndOf:function(elem){var rightEdge=this.getRightEdgeFor(elem);this.$content.scrollLeft+=rightEdge+1;return this;},getLeftEdgeFor:function(elem){var leftOffset=elem.getBoundingClientRect().left;return leftOffset-this.$content.getBoundingClientRect().left;},getRightEdgeFor:function(elem){var elemWidth=elem.offsetWidth,leftEdge=this.getLeftEdgeFor(elem);return leftEdge+elemWidth-this.$content.offsetWidth;},onToStartClick:function(event){var elem=event.originalEvent.currentTarget;event.stopPropagation();this.toStartOf(elem);},onToEndClick:function(event){var elem=event.originalEvent.currentTarget;event.stopPropagation();this.toEndOf(elem);},onScaleChange:function(){this._update=true;},onEventElementRender:function(){this._update=true;},onWindowResize:function(){this._update=true;},onContentScroll:function(){this._update=true;},onDataReloaded:function(){this._update=true;}});});